package presentation;

import javax.swing.JPanel;
import java.awt.Frame;
import javax.swing.JDialog;
import javax.swing.JLabel;
import java.awt.Rectangle;
import javax.swing.JComboBox;
import javax.swing.JButton;
import presentation.graph.GraphFactory;

/**
 * Dialog that allow to choose the layout for the graph
 */
public class ChoiceLayoutDialog extends JDialog {

	private static final long serialVersionUID = 1537787927972838799L;

	private String layout = null;
	
	private JPanel choiceLayoutContentPane = null;
	private JLabel choiceLayoutLabel = null;
	private JComboBox choiceLayoutComboBox = null;
	private JButton okButton = null;
	private JButton cancelButton = null;
	

	/**
	 * This is the default constructor
	 * @param owner the main frame
	 */
	public ChoiceLayoutDialog(Frame owner) {
		super(owner);
		initialize();
	}

	/**
	 * This method initializes this
	 */
	private void initialize() {
		this.setSize(300, 200);
		this.setContentPane(getChoiceLayoutContentPane());
		this.setResizable(false);
		this.setModal(true);
		this.setTitle("Choice Graph Layout");
		this.setVisible(true);
	}

	/**
	 * This method initializes choiseLayoutContentPane
	 * 
	 * @return javax.swing.JPanel
	 */
	private JPanel getChoiceLayoutContentPane() {
		if (choiceLayoutContentPane == null) {
			choiceLayoutLabel = new JLabel();
			choiceLayoutLabel.setBounds(new Rectangle(45, 15, 196, 16));
			choiceLayoutLabel.setText("Layout: ");
			choiceLayoutContentPane = new JPanel();
			choiceLayoutContentPane.setLayout(null);
			choiceLayoutContentPane.add(choiceLayoutLabel, null);
			choiceLayoutContentPane.add(getChoiceLayoutComboBox(), null);
			choiceLayoutContentPane.add(getOkButton(), null);
			choiceLayoutContentPane.add(getCancelButton(), null);
		}
		return choiceLayoutContentPane;
	}

	/**
	 * This method initializes choiseLayoutComboBox	
	 * 	
	 * @return javax.swing.JComboBox	
	 */
	private JComboBox getChoiceLayoutComboBox() {
		if (choiceLayoutComboBox == null) {
			choiceLayoutComboBox = new JComboBox(GraphFactory.layouts);
			choiceLayoutComboBox.setBounds(new Rectangle(45, 60, 196, 31));
			choiceLayoutComboBox.setToolTipText("Choose a layout for the graph");
		}
		return choiceLayoutComboBox;
	}

	/**
	 * This method initializes okButton	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getOkButton() {
		if (okButton == null) {
			okButton = new JButton();
			okButton.setBounds(new Rectangle(45, 120, 76, 31));
			okButton.setText("Ok");
			okButton.addActionListener(new java.awt.event.ActionListener() {
				public void actionPerformed(java.awt.event.ActionEvent e) {
					layout = (String)choiceLayoutComboBox.getSelectedItem();
					closeDialog();
				}
			});
		}
		return okButton;
	}

	/**
	 * This method initializes cancelButton	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getCancelButton() {
		if (cancelButton == null) {
			cancelButton = new JButton();
			cancelButton.setBounds(new Rectangle(165, 120, 76, 31));
			cancelButton.setText("Cancel");
			cancelButton.addActionListener(new java.awt.event.ActionListener() {
				public void actionPerformed(java.awt.event.ActionEvent e) {
					layout = null;
					closeDialog();
				}
			});
		}
		return cancelButton;
	}
	
	/**
	 * close dialod
	 */
	private void closeDialog()
	{
		this.setVisible(false);
	}

	/**
	 * return the name of the selected layout
	 * @return the name of layout
	 */
	public String getGraphLayout() {
		return layout;
	}
}
